#ifndef _GRAF_PLAYER_APP
#define _GRAF_PLAYER_APP


#include "ofMain.h"
#include "grafTagMulti.h"
#include "grafIO.h"
#include "grafPlayer.h"
#include "grafCurveSmoother.h"
#include "grafDrawer.h"
#include "pocoDirectoryLister.h"
#include "grafVParticleField.h"
#include "ofxControlPanel.h"
#include "ofxXmlSettings.h"
#include "ofThreadedImage.h"

#define TAG_DIRECTORY	"tags/"

enum{ PLAY_MODE_LOAD, PLAY_MODE_PLAY };

class grafPlayerApp{

	public:

		grafPlayerApp();
		~grafPlayerApp();
		void setup();
		void update();
		void draw();

		void keyPressed  (int key);
		void keyReleased(int key);
		void mouseMoved(int x, int y );
		void mouseDragged(int x, int y, int button);
		void mousePressed(int x, int y, int button);
		void mouseReleased(int x, int y, int button);
		
		void preLoadTags();
		void loadTags();
	
		void resetPlayer(int next);
		void nextTag(int dir=1);
		void clearAll();
	
		void setupContolPanel();
		void updateConrolPanel();
		
		string getCurrentTagName();
	
	
		//---------- loading data
		grafIO					gIO;					// pour charger et sauvegarder les fichiers GML
		ofxPocoDirectoryLister	dirLister;				// recherche le répertoire des fichiers GML
		string					myTagDirectory;			// répertoire de chargement (modifiable ici > data/settings/directorySettings.xml
		int						totalToLoad;			// nombre de fichiers GML à charger
		vector<string>			filesToLoad;			// Liste de toutes les adresses de fichier
		vector<string>			filenames;				// Liste des nom de fichier (sans .gml)
	
	
	
		//---------- tags GML
		vector<grafTagMulti> tags;						
	
		//---------- Lecteur pour lire les tags 
		grafPlayer	myTagPlayer;					
		
		//---------- courbes lissées pour de jolis dessins
		grafCurveSmoother smoother;
	
		//---------- dessins
		grafDrawer			drawer;					// dessins de l'épaisseur de la ligne dans le temps
		grafVParticleField	particleDrawer;			// dessins et animations des particules
		float				rotationY;				// rotation en y pour le tag actuel
		ofPoint				tagPosVel;				// accélération pour le mouvement autour du tag 
		float				tagMoveForce;			// force pour le mouvement autour du tag
		ofTrueTypeFont		fontS;					// fontes utilisées pour les informations
		ofTrueTypeFont		fontL;
		ofTrueTypeFont		fontSS;
		int					prevStroke;				// aide à l'animation des particules pour des tags à plusieurs traits
		float				fogStart,fogEnd;		// paramètre pour le "brouillard"
		float				dt;
		ofImage				imageMask;
	
	
		//---------- id of the current tag being played
		int currentTagID;
	
		//---------- 
		float					waitTimer;			// décompte du temps après la fin de l'animation
		float					waitTime;			// temps de pause
		
		//---------- application settings
        bool            bShiftOn;
		int             screenW,screenH;
		float			lastX,lastY;
		ofxThreadedImageSaver imgsaver;
	

		//---------- controls
		ofxControlPanel		panel;
		bool				bShowPanel;			// règlage du panel on/off
		bool				bRotating;			// réglage de la rotation automatique on/off
		bool				bShowName;			// réglage de l'affichage du nom de fichier
		bool				bShowTime;			// réglage pour l'affichage du temps
		bool				bUseFog;			// réglage du "brouillard"
		bool				bUseMask;			// réglage du masque des bords de l'écran
		bool				bTakeScreenShot;	
		bool				bUseGravity;
	
		int					mode;				// mode de lecture actuel PLAY_MODE_LOAD pour le chargement, PLAY_MODE_PLAY pour la lecture normale
	
	
	
	
	
};

#endif
